
-- ALTERANDO STATUS DO EMITENTE QUANDO ALTERADO O STATUS DO CLIENTE
-- 
CREATE TRIGGER [dbo].[TRG_RC_CLI_CHQ_EMI_ALTER] ON [dbo].[RC_CLI] 
FOR UPDATE
AS

DECLARE @EXISTE_EMI INT
	
BEGIN TRY
	--Se alterou o status do cliente ento altere o status do emitente
	-- quando o EMITENTE (FLAG_BLOQ_EMI=0), ou seja, permisso para bloqueia o emitente
	
	BEGIN
	    SET @EXISTE_EMI = (
		SELECT
		 COUNT(1)
		FROM
		INSERTED C INNER JOIN RC_CLI_CHQ_EMI CH ON
			C.CD_EMP=CH.CD_EMP
			AND C.CD_CLI=CH.CD_CLI 
			
			INNER JOIN CHQ_EMI ON
			CHQ_EMI.CD_EMP=CH.CD_EMP 
			AND CHQ_EMI.CD_EMI=CH.CD_EMI 
			AND FLAG_BLOQ_EMI=0
			)
		------------------------------------------------------------------------------------------------------------------------
		-- Trocando o status do emitente
		------------------------------------------------------------------------------------------------------------------------
		IF @EXISTE_EMI > 0
			BEGIN
				UPDATE CHQ_EMI 
						SET CHQ_EMI.STS_EMI = CASE WHEN   (ISNULL(c.STS_CLI,0) + ISNULL(c.STS_CRED,0)) > 0 THEN 1 ELSE 0 END
				FROM
				INSERTED C INNER JOIN RC_CLI_CHQ_EMI CH ON
					C.CD_EMP=CH.CD_EMP
					AND C.CD_CLI=CH.CD_CLI 
					
					INNER JOIN CHQ_EMI ON
					CHQ_EMI.CD_EMP=CH.CD_EMP 
					AND CHQ_EMI.CD_EMI=CH.CD_EMI 
					AND FLAG_BLOQ_EMI=0
			END

	END
END TRY

BEGIN CATCH
	ROLLBACK TRAN
	INSERT INTO ADM_ERRO (numero, severidade, estado, rotina, linha, mensagem, dtErro)
		SELECT
			ERROR_NUMBER() AS numero,
			ERROR_SEVERITY() AS severidade,
			ERROR_STATE() AS estado,
			ERROR_PROCEDURE() AS rotina,
			ERROR_LINE() AS linha,
			ERROR_MESSAGE() AS mensagem,
			GETDATE() AS dtErro;	
END CATCH					
 
 
